/******************************************************************************
* This module contains RF4CE ZRC profile type and API definitions.
*
* Copyright (c) 2009, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
******************************************************************************/
#ifndef _ZRC_PROFILE_INTERFACE_H_
#define _ZRC_PROFILE_INTERFACE_H_


#include "EmbeddedTypes.h" 
#include "NwkInterface.h" 

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/

#define gZRCProfileId_c       0x01

/* ZRC profile attributes Ids */
#define gKeyRepeatIntervalAttrId_c   0x80
#define gKeyRepeatWaitTimeAttrId_c   0x81
#define gKeyExTransferCountAttrId_c  0x82
#define gReceiveKeyRepeatCnfAttrId_c 0x90  /* This is a Freescale specific attribute Id */

/* Commands supported field size(in bytes) */
#define gCmdsSupportedFieldLength_c 32
/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

/* Messages types used for informing the application about confirms or indications from 
   ZRC profile arrived trough the ZRC SAP */
typedef enum {  
  gZRCProfileCommandInd_c          = 0x02, /* backward compatibility */ 
  gZRCProfileCommandCnf_c          = 0x03, /* backward compatibility */ 
  gZRCProfileDiscoveryCmdCnf       = 0x06, /* backward compatibility */ 
  /*---------------------------*/
  gZRCProfileMax_c  
}zrcProfileToAppMsgType_t;



/* Structure of the ZRC Profile to Application SAP messages */


/* Command indication */
/*------------------------------------------------------*/
typedef struct zrcProfileCommandInd_tag 
{ 
  uint8_t     deviceId; 
  uint8_t     dataLength; 
  uint8_t     vendorId[2]; 
  uint8_t     LQI; 
  uint8_t     rxFlags; 
  uint8_t     commandCode; 
  uint8_t     command; 
  uint8_t*    pData; 
}zrcProfileCommandInd_t; 




/* Command confirm */
/*------------------------------------------------------*/
typedef struct zrcProfileCommandCnf_tag
{
  uint8_t     status;
  uint8_t     deviceId; 
  uint8_t     commandCode;
  uint8_t     command;
}zrcProfileCommandCnf_t;

/* Command confirm */
/*------------------------------------------------------*/
typedef struct zrcProfileDiscoveryCmdCnf_tag
{
  uint8_t     status;
  uint8_t     deviceId; 
  uint8_t     cmdSupportedBitMap[gCmdsSupportedFieldLength_c];
}zrcProfileDiscoveryCmdCnf_t;


/* General structure of a message received by the application over ZRC Profile SAP */
typedef struct zrcProfileToAppMsg_tag 
{
  zrcProfileToAppMsgType_t               msgType;
  union {
    /*------------------------------------------------------*/
    zrcProfileCommandInd_t                     zrcProfileCommandInd;
    zrcProfileCommandCnf_t                     zrcProfileCommandCnf;
    zrcProfileDiscoveryCmdCnf_t                zrcProfileDiscoveryCmdCnf;
  } msgData;
}zrcProfileToAppMsg_t;


/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

 
/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/


/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/


/************************************************************************************
* ZRCProfile_Init
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void ZRCProfile_Init(void);

/************************************************************************************
* ZRCProfile_InitCommandTxRx
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t ZRCProfile_InitCommandTxRx(void);


/************************************************************************************
* ZRCProfile_CommandRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t ZRCProfile_CommandRequest(
                                    uint8_t   deviceId, 
                                    uint8_t   commandCode,
                                    uint8_t   command,
                                    uint8_t*  vendorId,
                                    uint8_t   payloadLength,
                                    uint8_t*  payload,
                                    uint8_t   txOptions
                                    );
                                              
/************************************************************************************
* ZRCProfile_AbortProcess
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t ZRCProfile_AbortProcess(void);


/************************************************************************************
* ZRCProfile_IsIdle
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
bool_t ZRCProfile_IsIdle(void);

/************************************************************************************
* ZRCProfile_HandleNwkNldeMsg
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void ZRCProfile_HandleNwkNldeMsg(
                                 nwkNldeToAppMsg_t *pMsg
                                 );                                 


/************************************************************************************
* ZRCProfile_App_SapHandler
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void ZRCProfile_App_SapHandler(
                               zrcProfileToAppMsg_t* zrcProfileToAppMsg
                               );
                               
/************************************************************************************
* ZRCProfile_GetRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
* status  gNWUnsupportedAttribute_c  
*         gNWSuccess_c 
* 
************************************************************************************/
uint8_t ZRCProfile_GetRequest(
                               uint8_t attrId, /* IN*/
                               uint8_t *pAttrLength, /* OUT */
                               uint8_t* pAttrValue /* OUT*/
                              );   

/************************************************************************************
* ZRCProfile_SetRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
* status  gNWUnsupportedAttribute_c  
*         gNWSuccess_c
*         gNWInvalidParam_c 
* 
************************************************************************************/
uint8_t ZRCProfile_SetRequest(
                               uint8_t attrId, /* IN */ 
                               uint8_t*pAttrValue /* IN */
                              );                            

#endif  /* _ZRC_PROFILE_INTERFACE_H_ */
